function [struct_param, endo_ss, phis] = calibrate_ss(estim_param, calib_targets)
% This function finds the structural parameters given a set of structural
% parameters to be estimated and calibration targets. The calibration
% targets include both extraction rates, OPEC's market share, the share
% of oil revenues out of world GDP, and the level of labor.
% Parameters to be calibrated: G_N, G_O, xi, s_o, and varphi

est_par_names = {'beta', 'epsilon', 'alpha', 'eta', 'lambda', 'nu', 'delta', 'gamma'}; % 'psi',
for i = 1:length(est_par_names)
    eval([est_par_names{i} ' = estim_param.' est_par_names{i} ';']);
end
cal_tar_names = {'theta_n', 'theta_o', 'MS_o', 'R_o', 'L'};
for i = 1:length(cal_tar_names)
    eval([cal_tar_names{i} ' = calib_targets.' cal_tar_names{i} ';']);
end

% keyboard
options = optimset('MaxFunEvals', 100000);
x_ss = fminsearch(@(x) sum(calibrate_ss_resid(exp(x(1))/(1+exp(x(1))), estim_param, calib_targets).^2), [0], options);
evalc('x_ss = fsolve(@(x) calibrate_ss_resid(exp(x)/(1+exp(x)), estim_param, calib_targets), x_ss);');

xi = exp(x_ss)/(1+exp(x_ss));
[resid, struct_param, endo_ss, phis] = calibrate_ss_resid(xi, estim_param, calib_targets);

